           org 100h

           mov  al,12h   ; set mode to 640x480x16
           int  10h
           push 0A000h
           pop  ds

           ; start line from (0,0) to (639,479)
           xor  si,si    ; top most pixel (0,0)
           mov  al,0     ; start with color 0
           mov  cx,480   ; 480 pixels
DrawLine:  call PutPixel ; put the pixel
           inc  bx
           inc  si
           inc  ax
           and  al,0Fh
           loop DrawLine

           xor  ah,ah   ; wait for key press
           int  16h

PutPixel:  pusha  ; bx=X si=y al=color
           push ax

           imul si,80
           mov  cl,7
           and  cl,bl      ; cl = x&7
           shr  bx,3       ; offset = y*(width>>3) + (x >> 3)

           mov  dx,03CEh   ; set to video hardware controller
           mov  ax,0x8008
           shr  ah,cl      ; 0xmm08, m = 0x80>>(x&7)
           out  dx,ax
           mov  ax,0x0205  ; read mode 0, write mode 2
           out  dx,ax

           mov  al,[bx+si] ; load to latch register
           pop  ax
           mov  [bx+si],al ; write to register

           popa
           ret
